<?php

//------------------------------------------------------------------------------
// LANGUAGE FILE
// Edit with care. Make a backup first before making changes.
//
// [1] Apostrophes should be escaped. eg: it\'s christmas.
// [2] Take care when editing arrays as they are spread across multiple lines
//
// If you make a mistake and you see a parse error, revert to backup file
//------------------------------------------------------------------------------

/*---------------------------------------------
CHARACTER SET
For encoding HTML characters
Unless specified in language file,
this may not need altering.
----------------------------------------------*/


$msg_charset = 'utf-8';
$msg_pipe_charset = 'utf-8';
$mail_charset = 'utf-8';
$html_lang = 'en';
$lang_dir = 'ltr';

$msg_header = '{website}';
$msg_header2 = 'Logout';
$msg_header3 = 'My Account';
$msg_header4 = 'Search Tickets';

$msg_main2 = 'Open New Ticket';
$msg_main3 = 'Email Address';
$msg_main4 = 'Password';
$msg_main5 = 'Get New Password';
$msg_main8 = 'No active account found, please check and try again..';
$msg_main9 = 'Forgot Password?';
$msg_main10 = 'Popular Questions';
$msg_main11 = 'View';
$msg_main13 = 'Invalid email address, please check and try again..';

$msg_pkbase = 'Search';
$msg_pkbase2 = 'Enter Keywords';
$msg_pkbase3 = 'Search';
$msg_pkbase4 = 'Categories <span class="normal">({count})</span>';
$msg_pkbase5 = 'Most Popular {count} Questions';
$msg_pkbase7 = 'All F.A.Q Categories';
$msg_pkbase8 = 'No entries found';
$msg_pkbase10 = 'No categories found in F.A.Q.';
$msg_pkbase11 = 'Last Updated: {date}';
$msg_pkbase17 = 'Add to Favourites';
$msg_pkbase18 = 'Print Article';

$msg_portal = 'Your Account';
$msg_portal2 = 'Ticket Status &amp; Updates';
$msg_portal3 = 'Update Password';
$msg_portal4 = 'Enter New Password (Min {min} Chars)';
$msg_portal6 = 'Open Tickets / Disputes';
$msg_portal7 = 'You currently have 0 tickets to display. Previous tickets may have been deleted.';
$msg_portal8 = 'View Ticket';
$msg_portal9 = 'Opened';
$msg_portal10 = 'Priority';
$msg_portal11 = 'Department';
$msg_portal12 = 'Status';
$msg_portal13 = 'My Tickets';
$msg_portal14 = 'Password Too Short..Min {min} Chars..';
$msg_portal15 = 'Ticket Closed';
$msg_portal16 = 'Open New Ticket';
$msg_portal17 = 'Search Results';
$msg_portal19 = 'Replies';
$msg_portal20 = 'Search Results ({count})';
$msg_portal21 = 'Your search generated 0 results. Previous tickets may have been deleted.';
$msg_portal22 = 'Password Updated';

$msg_newticket = 'Open New Ticket';
$msg_newticket3 = 'Your Name';
$msg_newticket4 = 'Email Address';
$msg_newticket5 = 'Comments (Click the <i class="fa fa-arrows-alt fa-fw" style="font-size:12px"></i> icon to expand textarea)';
$msg_newticket6 = 'Department';
$msg_newticket7 = 'Comments';
$msg_newticket8 = 'Priority';
$msg_newticket9 = 'Low';
$msg_newticket10 = 'Medium';
$msg_newticket11 = 'High';
$msg_newticket13 = 'Open New Ticket';
$msg_newticket15 = 'Subject';
$msg_newticket24 = 'Security words incorrect. Please try again...';
$msg_newticket26 = 'For Spam Prevention, please complete the following:';

$msg_showticket = 'Details';
$msg_showticket2 = 'No Ticket Found';
$msg_showticket3 = 'There are currently 0 replies to this ticket.';
$msg_showticket4 = 'Viewing Ticket: #{ticket}';
$msg_showticket5 = 'Close Ticket - Do you wish to close this ticket after this response?';
$msg_showticket6 = 'Attach Another File';
$msg_showticket8 = 'Reply Successfully Added';
$msg_showticket9 = 'Name';
$msg_showticket10 = 'Email';
$msg_showticket11 = 'Department';
$msg_showticket12 = 'Ticket Date/Time';
$msg_showticket13 = 'IP Address';
$msg_showticket14 = 'Status';
$msg_showticket15 = 'Details';
$msg_showticket16 = 'Priority';
$msg_showticket17 = 'Add Reply';
$msg_showticket18 = 'Ticket ID';
$msg_showticket19 = '#{ticket}';
$msg_showticket20 = 'This ticket currently has 0 replies.';
$msg_showticket21 = 'Reply by';
$msg_showticket22 = '{count} attachment(s)';
$msg_showticket23 = 'Open';
$msg_showticket24 = 'Closed';
$msg_showticket27 = 'This dispute currently has 0 replies.';

$msg_adheader = 'Helpdesk CP';
$msg_adheader2 = 'Settings';
$msg_adheader3 = 'Departments';
$msg_adheader4 = 'Support Team';
$msg_adheader5 = 'Open Tickets';
$msg_adheader6 = 'Closed Tickets';
$msg_adheader7 = 'Search Tickets';
$msg_adheader8 = 'Questions & Answers';
$msg_adheader9 = 'Purchase Full Version';
$msg_adheader10 = 'Logout';
$msg_adheader11 = 'Dashboard';
$msg_adheader12 = 'Help';
$msg_adheader13 = 'Standard Responses';
$msg_adheader14 = 'Tickets';
$msg_adheader15 = 'Tools';
$msg_adheader16 = 'Categories';
$msg_adheader17 = 'F.A.Q';
$msg_adheader18 = 'System Tools';
$msg_adheader19 = 'Import Options';
$msg_adheader20 = 'Entry Log';
$msg_adheader21 = 'Portal Options';
$msg_adheader22 = 'No Access';
$msg_adheader23 = 'Send Message to Other Users';

$msg_dept = 'Add';
$msg_dept2 = 'Add Department';
$msg_dept3 = 'Delete';
$msg_dept4 = 'Current Departments';
$msg_dept5 = 'Update Department';
$msg_dept6 = 'Edit';
$msg_dept7 = 'Department Added';
$msg_dept8 = 'There are currently 0 departments to display.';
$msg_dept9 = 'Manage Departments';
$msg_dept10 = 'Update';
$msg_dept11 = 'Cancel';
$msg_dept12 = 'Department Updated';
$msg_dept13 = 'Selected Department(s) Deleted';

$msg_home2 = 'System Overview';
$msg_home3 = 'Ticket Overview';
$msg_home4 = 'New (Waiting for Support Team)';
$msg_home5 = 'Open (Waiting for Support Team)';
$msg_home6 = 'Open (Waiting for Visitor)';
$msg_home7 = 'Closed';
$msg_home8 = '<a href="?p=teamman">{users} Support Team Staff</a>';
$msg_home9 = '<a href="?p=standard-responses">{responses} Standard Responses</a>';
$msg_home10 = '<a href="?p=faqman">{questions} F.A.Q</a> in <a href="?p=faq-catman">{cats} Categories</a> with <a href="?p=attachman">{attachments} Attachments</a>';
$msg_home11 = 'You do not have permission to view the selected page.';
$msg_home12 = 'Ticket Statistics (ALL)';
$msg_home13 = 'Last 7 Days';
$msg_home14 = 'Last {count} Weeks';
$msg_home15 = 'Last Month';
$msg_home16 = 'Last {count} Months';
$msg_home17 = 'Last Year';
$msg_home18 = 'Filter';
$msg_home19 = 'All';
$msg_home20 = 'There is no ticket data to display';
$msg_home21 = 'Tickets';
$msg_home22 = 'Replies';
$msg_home23 = 'WARNING! Please remove or rename the \'install\' directory. This is a major security risk. (<a href="#" onclick="jQuery(\'#ew_1\').hide(\'slow\');return false" style="color:#fff">Close</a>)';
$msg_home24 = 'MESSAGE! Don`t forget to update the \'ENABLE_MYSQL_ERRORS\' option in the "control/connect.php" file to disable showing MySQL errors.
                              You should always disable this and show a default message when the system is live. This message is a kindly reminder and will disappear once the option is updated. (<a href="#" onclick="jQuery(\'#ew_3\').hide(\'slow\');return false" style="color:#fff">Close</a>)';
$msg_home25 = 'MESSAGE! You should rename the SECRET_KEY value in the "control/connect.php" file. This message is a kindly reminder and will disappear once the option is updated. (<a href="#" onclick="jQuery(\'#ew_2\').hide(\'slow\');return false" style="color:#fff">Close</a>)';

$msg_kbasecats = 'Category Added';
$msg_kbasecats2 = 'Add New Category';
$msg_kbasecats3 = 'Delete';
$msg_kbasecats4 = 'Current Categories';
$msg_kbasecats5 = 'Update Category';
$msg_kbasecats6 = 'Edit';
$msg_kbasecats7 = 'Category Updated';
$msg_kbasecats8 = 'There are currently 0 categories to display';
$msg_kbasecats9 = 'F.A.Q quecategory.';
$msg_kbasecats10 = 'Update';
$msg_kbasecats11 = 'Cancel';
$msg_kbasecats12 = 'Selected Categories Deleted';

$msg_kbase = 'Question';
$msg_kbase2 = 'Answer';
$msg_kbase3 = 'Add New Question';
$msg_kbase4 = 'Current Questions';
$msg_kbase5 = 'Category';
$msg_kbase6 = 'All Categories';
$msg_kbase7 = 'Question Added';
$msg_kbase8 = 'Question Updated';
$msg_kbase9 = 'There are currently 0 questions/answers to display';
$msg_kbase10 = 'Selected Question(s) Deleted';
$msg_kbase12 = 'Preview';
$msg_kbase13 = 'Update Question';
$msg_kbase15 = 'Summary';
$msg_kbase16 = 'Add Category';
$msg_kbase17 = 'Category Name';
$msg_kbase18 = '{count} Vote(s) - {helpful}% <i class="fa fa-thumbs-up fa-fw"></i> / {nothelpful}% <i class="fa fa-thumbs-down fa-fw"></i>';
$msg_kbase21 = 'Selected Voting Count(s) Reset';

$msg_log = 'Name/Alias';
$msg_log2 = 'Clear Log';
$msg_log3 = 'Export Log to CSV';
$msg_log4 = 'There are currently 0 entries in the log.';
$msg_log5 = 'Log File Cleared';

$msg_messenger = 'Use the box below to send an email to all selected users of the support team. Users with notification off are not shown.';
$msg_messenger2 = 'Send Message';
$msg_messenger3 = 'Copy Message to: &quot;<b>{email}</b>&quot;';
$msg_messenger4 = 'Message Sent';
$msg_messenger5 = 'Message from Support Team: {user}';
$msg_messenger6 = '[Copy] Message from Support Team: {user}';

$msg_response = 'Title';
$msg_response2 = 'Answer';
$msg_response3 = 'Add New Response';
$msg_response4 = 'Current Responses';
$msg_response5 = 'Department';
$msg_response6 = 'All Departments';
$msg_response7 = 'Response Added';
$msg_response8 = 'Response Updated';
$msg_response9 = 'There are currently 0 standard responses to display.';
$msg_response10 = 'Selected Response(s) Deleted';
$msg_response12 = 'Preview';
$msg_response13 = 'Update Response';
$msg_response14 = 'Batch Import';
$msg_response15 = '(In Department: {dept})';

$msg_systemportal = 'Enter Email Address';
$msg_systemportal2 = 'Enter New Password';
$msg_systemportal3 = 'Reset Portal Password';
$msg_systemportal5 = 'Send Email';
$msg_systemportal6 = 'Move Tickets to Another Account';
$msg_systemportal8 = 'Enter Destination Email Address';
$msg_systemportal9 = 'Update';
$msg_systemportal11 = 'Password Reset';
$msg_systemportal12 = 'Email Address Not Found..';
$msg_systemportal13 = '{count} Tickets Moved';
$msg_systemportal15 = 'Export Portal Data to CSV';
$msg_systemportal16 = 'Export Name';
$msg_systemportal17 = 'Export Email Address';
$msg_systemportal18 = 'Export';

$msg_import = 'Batch Import Standard Responses';
$msg_import2 = 'Batch Import F.A.Q Entries';
$msg_import4 = 'Clear Existing';
$msg_import5 = 'Locate CSV File';
$msg_import6 = 'Lines to Read';
$msg_import7 = 'Delimited by';
$msg_import8 = 'Enclosed by';
$msg_import9 = 'Import Standard Responses';
$msg_import10 = 'Categories';
$msg_import11 = 'Import F.A.Q Entries';
$msg_import12 = 'All Categories';
$msg_import13 = '{count} Standard Responses Imported';
$msg_import14 = '{count} F.A.Q Questions Imported';
$msg_import15 = 'Example CSV';

$msg_login = 'Administration Login';
$msg_login2 = 'Password';
$msg_login3 = 'Remember Me?';
$msg_login4 = 'No account found...please try again..';
$msg_login5 = 'Enter';
$msg_login6 = 'Please enter your valid email..';
$msg_login7 = 'Please enter your password..';
$msg_login8 = 'Email Address';
$msg_login9 = 'Sign In';

$msg_merge = 'Select Parent Ticket';
$msg_merge2 = 'Select New Parent Ticket';

$msg_open = 'Add New Ticket';
$msg_open2 = 'All Departments';
$msg_open3 = 'All Statuses &amp; Priority Levels';
$msg_open4 = 'Low Priority';
$msg_open5 = 'Medium Priority';
$msg_open6 = 'High Priority';
$msg_open7 = 'View Ticket';
$msg_open8 = 'Opened by: <span class="highlight">{name}</span> on <span class="highlight">{date}</span> &#8226; Dept: <span class="highlight">{dept}</span> &#8226; Replies: <span class="highlight">{replies}</span>';
$msg_open9 = 'From';
$msg_open10 = 'There are currently no tickets to display.';
$msg_open11 = 'Open - Waiting for Support Team';
$msg_open12 = 'Open - Waiting for Visitor';
$msg_open13 = 'Closed';
$msg_open14 = 'Permanently Closed &amp; Resolved';
$msg_open15 = 'Delete Selected Ticket(s)';
$msg_open16 = 'Selected Ticket(s) Deleted';
$msg_open17 = '<span class="highlight"><b>{count}</b></span> closed ticket(s). Closed tickets must be re-opened to add new replies.';
$msg_open18 = 'Check All';
$msg_open19 = 'Re-Open Ticket';
$msg_open20 = 'Ticket Re-Opened';
$msg_open21 = 'Selected Ticket(s) Deleted';

$msg_search = 'Basic Search';
$msg_search2 = 'Search Tickets';
$msg_search3 = 'Keyword or Ticket ID';
$msg_search4 = 'Department';
$msg_search5 = 'Priority';
$msg_search6 = 'Search Results';
$msg_search7 = 'Date From/To';
$msg_search8 = 'Ticket Status';
$msg_search9 = 'Please specify some search parameters..';
$msg_search10 = 'No results found for the specified search parameters.';
$msg_search11 = 'Ticket Type';

$msg_settings = 'Enable F.A.Q';
$msg_settings2 = 'PHP Date/Time Format';
$msg_settings3 = 'Enable Attachments';
$msg_settings4 = 'Allowable File Extensions';
$msg_settings5 = 'Max Size for Attachments';
$msg_settings7 = 'Update Settings';
$msg_settings8 = 'Settings Updated';
$msg_settings9 = 'Help Desk Name';
$msg_settings10 = 'Date/Time';
$msg_settings12 = 'Default Timezone';
$msg_settings13 = 'Auto Close Duration';
$msg_settings14 = 'Days';
$msg_settings15 = 'Enable SMTP Debugging';
$msg_settings16 = 'SMTP Host';
$msg_settings17 = 'SMTP Username';
$msg_settings18 = 'SMTP Password';
$msg_settings19 = 'SMTP Port / Security';
$msg_settings20 = 'HTTP Installation Path';
$msg_settings21 = 'Email Notification "From" Address';
$msg_settings22 = 'General';
$msg_settings23 = 'Attachments';
$msg_settings24 = 'SMTP';
$msg_settings25 = 'Total Attachment Boxes';
$msg_settings26 = 'MySQL Date Format';
$msg_settings27 = 'Server Path to Attachments Folder';
$msg_settings28 = 'Auto Create Hyperlinks';
$msg_settings29 = 'F.A.Q';
$msg_settings30 = 'Admin Folder Name';
$msg_settings32 = 'Enable Multiple Votes';
$msg_settings33 = 'Total Popular/Latest Questions on Main Page';
$msg_settings34 = 'Cookie Duration (in Days)';
$msg_settings36 = 'Show Calculator';
$msg_settings53 = 'hours';
$msg_settings54 = 'Admin Footer';
$msg_settings55 = 'Public Footer';
$msg_settings56 = 'Edit Footers';
$msg_settings57 = 'Enable Voting System';

$msg_tools = 'This feature enables you to purge certain data from the system that is a certain amount of days old. This can be useful if you have lots of data and need to do a clean up. Note that this action is irreversible.';
$msg_tools2 = 'Purge Closed Tickets X Days Old';
$msg_tools3 = 'Purge Closed Tickets X Days Old';
$msg_tools4 = 'Purge';
$msg_tools5 = 'Clear Attachments';
$msg_tools6 = 'Clear ticket attachments only X days old';
$msg_tools7 = 'Department';
$msg_tools8 = '<i class="fa fa-check fa-fw"></i> {count1} Ticket(s) Deleted<br><i class="fa fa-check fa-fw"></i> {count2} Replies Deleted<br><i class="fa fa-check fa-fw"></i> {count3} Attachment(s) Deleted';
$msg_tools9 = '<i class="fa fa-check fa-fw"></i> {count} Attachment(s) Deleted';
$msg_tools10 = 'All Departments';

$msg_user = 'Name/Alias';
$msg_user2 = 'Add New Staff';
$msg_user3 = 'Staff';
$msg_user4 = 'Email Address';
$msg_user5 = 'Department Access';
$msg_user6 = 'User Added';
$msg_user7 = 'Name';
$msg_user8 = 'Department';
$msg_user9 = 'Email';
$msg_user10 = 'User Details';
$msg_user11 = 'There are currently 0 staff members to display.';
$msg_user12 = 'Login Password';
$msg_user13 = 'Selected Staff Member(s) Deleted';
$msg_user14 = 'Update Staff';
$msg_user15 = 'Staff Updated';
$msg_user16 = 'Cancel';
$msg_user17 = 'Signature (Optional - HTML not allowed)';
$msg_user18 = 'Enable Email Notifications';
$msg_user19 = 'Signature';
$msg_user20 = 'Notification';
$msg_user22 = 'There are no responses to display for this staff member.';
$msg_user23 = 'Total Responses';
$msg_user25 = 'View All Responses';
$msg_user28 = 'Date Added';
$msg_user29 = 'View Ticket';
$msg_user30 = 'Ticket';
$msg_user31 = 'View Graph';
$msg_user39 = 'Change';
$msg_user40 = 'Administrator';
$msg_user41 = 'Staff Member Added &amp; Welcome Email Sent';

$msg_viewticket = 'Viewing Ticket: #{ticket}';
$msg_viewticket2 = 'Name';
$msg_viewticket3 = 'Email';
$msg_viewticket4 = 'Department';
$msg_viewticket5 = 'Please Select..';
$msg_viewticket6 = 'IP';
$msg_viewticket7 = 'Status';
$msg_viewticket8 = 'Details';
$msg_viewticket9 = 'Priority';
$msg_viewticket10 = 'Ticket: <b>#{ticket}</b>';
$msg_viewticket11 = 'Add Reply';
$msg_viewticket12 = 'Standard Responses';
$msg_viewticket13 = 'Add New Reply';
$msg_viewticket14 = 'Open';
$msg_viewticket15 = 'Closed';
$msg_viewticket16 = 'Locked';
$msg_viewticket17 = 'Status';
$msg_viewticket18 = 'Email Notification';
$msg_viewticket19 = '00000';
$msg_viewticket20 = 'Edit Ticket #{ticket}';
$msg_viewticket21 = 'Update Ticket';
$msg_viewticket22 = 'Comments';
$msg_viewticket23 = 'Support Ticket Successfully Updated';
$msg_viewticket24 = 'Already Exists in System';
$msg_viewticket25 = 'Subject';
$msg_viewticket26 = 'Open';
$msg_viewticket27 = 'Close';
$msg_viewticket28 = 'Lock';
$msg_viewticket29 = 'Viewing {count} Attachment(s): #{ticket}';
$msg_viewticket30 = 'Delete All';
$msg_viewticket32 = 'File &amp; Type';
$msg_viewticket33 = 'Size';
$msg_viewticket34 = 'Delete Selected Attachment(s)';
$msg_viewticket36 = 'Edit Ticket Reply';
$msg_viewticket37 = 'Update Ticket Reply';
$msg_viewticket38 = 'Ticket Reply Updated';
$msg_viewticket39 = 'There are currently 0 replies to this ticket.';
$msg_viewticket40 = 'Attachments';
$msg_viewticket41 = '{count} Attachment(s)';
$msg_viewticket42 = 'Reply by';
$msg_viewticket43 = 'Unknown';
$msg_viewticket44 = 'This reply has 0 attachments.';
$msg_viewticket45 = 'This ticket is currently closed and no replies can be added. Please <a href="{url}">re-open</a> to add reply.';
$msg_viewticket46 = 'Ticket Reply Deleted';
$msg_viewticket47 = 'Ticket Reply Successfully Added';
$msg_viewticket48 = 'Ticket Merged &amp; Reply Added';
$msg_viewticket50 = 'Download';

$msg_script = 'Maian Support';
$msg_script3 = 'Powered by';
$msg_script4 = 'Yes';
$msg_script5 = 'No';
$msg_script6 = 'Page/File Does Not Exist';
$msg_script7 = 'Optional';
$msg_script8 = 'Delete';
$msg_script9 = 'Edit';
$msg_script10 = 'View';
$msg_script11 = 'Pages';
$msg_script12 = 'All Rights Reserved';
$msg_script13 = 'Printer Friendly Version';
$msg_script14 = 'Print';
$msg_script15 = 'Close';
$msg_script16 = 'Forbidden: You do not have permission to view this page';
$msg_script17 = 'N/A';
$msg_script18 = 'Powered by';
$msg_script19 = 'Bytes';
$msg_script20 = 'Get Adobe Flash Player';
$msg_script21 = array(
  'Jan',
  'Feb',
  'Mar',
  'Apr',
  'May',
  'Jun',
  'Jul',
  'Aug',
  'Sep',
  'Oct',
  'Nov',
  'Dec'
);
$msg_script22 = 'Free Version Restriction';

$msg_piping = 'Are Connection Parameters Correct?';
$msg_piping2 = 'Is Username/Password valid?';
$msg_piping3 = 'Are flags set correctly? Contact host if not sure.';
$msg_piping4 = 'Have you specified correct protocol?';
$msg_piping5 = 'This function is not enabled';
$msg_piping6 = '[No Subject]';
$msg_piping7 = 'Sent via Email';
$msg_piping8 = 'Mailbox Read @ {datetime}. {count_msg} Messages Found.<br><br>{count4} Tickets Awaiting Assignment.<br>{count5} Tickets Accepted and Flagged as Spam.<br>{count6} Tickets Flagged as Spam and Auto Purged.<br>{count} New Tickets Opened.<br>{count2} Replies Added.<br>{count3} Attachment(s) Saved.<br><br>- - - - -<br><br>Memory Used: {memory}<br>Peak Memory Used: {peak}<br>Duration: {duration}';
$msg_piping9 = 'Server Imap Error';

?>