<?php

if (!defined('PARENT')) {
  msw403();
}

function dbConnectorTest($test = false) {
  $connect = @($GLOBALS["___mysqli_ston"] = mysqli_connect(DB_HOST, DB_USER, DB_PASS));
  if (!$connect) {
    if ($test) {
      return 'Connection Failed - Check Connection Parameters';
    }
    mswMysqlErrMsg(((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), __LINE__, __FILE__);
  }
  if ($connect && !((bool)mysqli_query( $connect, 'USE `' . DB_NAME . '`'))) {
    if ($test) {
      return 'Connection Failed - Check Connection Parameters';
    }
    mswMysqlErrMsg(((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), __LINE__, __FILE__);
  }
  if ($test) {
    return 'Connection Successful';
  }
}

function mswCheckTable($table) {
  $q = mysqli_query($GLOBALS["___mysqli_ston"], "SHOW TABLES WHERE `Tables_in_" . DB_NAME . "` = '" . DB_PREFIX . $table . "'");
  $c = mysqli_fetch_object(mysqli_query($GLOBALS["___mysqli_ston"], "SELECT FOUND_ROWS() AS `rows`"));
  $f = (isset($c->rows) ? $c->rows : '0');
  return ($f > 0 ? 'yes' : 'no');
}

function mswCheckColumnType($table, $field, $string) {
  $q = mysqli_query($GLOBALS["___mysqli_ston"], "SHOW FIELDS FROM `" . DB_PREFIX . $table . "` WHERE `Field` = '{$field}'");
  $R = mysqli_fetch_object($q);
  $f = (isset($R->Type) ? strtolower($R->Type) : '');
  return (strpos($f, strtolower($string)) !== false ? 'yes' : 'no');
}

function mswCheckColumn($table, $col) {
  $q = mysqli_query($GLOBALS["___mysqli_ston"], "SELECT count(*) AS `c` FROM `information_schema`.`COLUMNS` WHERE `TABLE_SCHEMA` = '" . DB_NAME . "'
        AND `TABLE_NAME`  = '" . DB_PREFIX . $table . "'
        AND `COLUMN_NAME` = '{$col}'
        ");
  $R = mysqli_fetch_object($q);
  $f = (isset($R->c) ? $R->c : '0');
  return ($f > 0 ? 'yes' : 'no');
}

function mswCheckIndex($table, $index) {
  $q = mysqli_query($GLOBALS["___mysqli_ston"], "SHOW INDEX FROM `" . DB_PREFIX . $table . "` WHERE `Key_name` = '$index'");
  $c = mysqli_fetch_object(mysqli_query($GLOBALS["___mysqli_ston"], "SELECT FOUND_ROWS() AS `rows`"));
  $f = (isset($c->rows) ? $c->rows : '0');
  return ($f > 0 ? 'yes' : 'no');
}

function mswUpgradeLog($text) {
  if (is_writeable(REL_PATH . 'logs')) {
    $header = '';
    if (!file_exists(REL_PATH . 'logs/upgrade-routine-log.txt')) {
      $query   = @mysqli_query($GLOBALS["___mysqli_ston"], "SELECT VERSION() AS `v`");
      $VERSION = @mysqli_fetch_object($query);
      $header  = 'Script: ' . SCRIPT_NAME . mswDefineNewline();
      $header .= 'Script Version: ' . SCRIPT_VERSION . mswDefineNewline();
      $header .= 'PHP Version: ' . phpVersion() . mswDefineNewline();
      $header .= 'MySQL Version: ' . (isset($VERSION->v) ? $VERSION->v : 'Unknown') . mswDefineNewline();
      if (isset($_SERVER['SERVER_SOFTWARE'])) {
        $header .= 'Server Software: ' . $_SERVER['SERVER_SOFTWARE'] . mswDefineNewline();
      }
      if (isset($_SERVER["HTTP_USER_AGENT"])) {
        if (strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'win')) {
          $platform = 'Windows';
        } else if (strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mac')) {
          $platform = 'Mac';
        } else {
          $platform = 'Other';
        }
        $header .= 'Platform: ' . $platform . mswDefineNewline();
      }
      $header .= '=================================================================================' . mswDefineNewline();
    }
    $string = date('d/m/Y H:i:s') . ': ' . $text . mswDefineNewline();
    $string .= '- - - - - - - - - - - - - - - - - - - - - ' . mswDefineNewline();
    @file_put_contents(REL_PATH . 'logs/upgrade-routine-log.txt', $header . $string, FILE_APPEND);
  }
}

function mswlogDBError($table, $error, $code, $line, $file, $type = 'Create') {
  $header = '';
  if (!file_exists(REL_PATH . 'logs/install-error-report.txt')) {
    $query   = @mysqli_query($GLOBALS["___mysqli_ston"], "SELECT VERSION() AS v");
    $VERSION = @mysqli_fetch_object($query);
    $header  = 'Script: ' . SCRIPT_NAME . mswDefineNewline();
    $header .= 'Script Version: ' . SCRIPT_VERSION . mswDefineNewline();
    $header .= 'PHP Version: ' . phpVersion() . mswDefineNewline();
    $header .= 'MySQL Version: ' . (isset($VERSION->v) ? $VERSION->v : 'Unknown') . mswDefineNewline();
    if (isset($_SERVER['SERVER_SOFTWARE'])) {
      $header .= 'Server Software: ' . $_SERVER['SERVER_SOFTWARE'] . mswDefineNewline();
    }
    if (isset($_SERVER["HTTP_USER_AGENT"])) {
      if (strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'win')) {
        $platform = 'Windows';
      } else if (strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mac')) {
        $platform = 'Mac';
      } else {
        $platform = 'Other';
      }
      $header .= 'Platform: ' . $platform . mswDefineNewline();
    }
    $header .= '=================================================================================' . mswDefineNewline();
  }
  $string = 'Table: ' . $table . mswDefineNewline();
  $string .= 'Operation: ' . $type . mswDefineNewline();
  $string .= 'Error Code: ' . $code . mswDefineNewline();
  $string .= 'Error Msg: ' . $error . mswDefineNewline();
  $string .= 'On Line: ' . $line . mswDefineNewline();
  $string .= 'In File: ' . $file . mswDefineNewline();
  $string .= '- - - - - - - - - - - - - - - - - - - - - ' . mswDefineNewline();
  if (is_writeable(REL_PATH . 'logs')) {
    file_put_contents(REL_PATH . 'logs/install-error-report.txt', $header . $string, FILE_APPEND);
  }
}

// Generates 60 character product key..
$_SERVER['HTTP_HOST']   = (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] ? $_SERVER['HTTP_HOST'] : uniqid(rand(), 1));
$_SERVER['REMOTE_ADDR'] = (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] ? $_SERVER['REMOTE_ADDR'] : uniqid(rand(), 1));

if (function_exists('sha1')) {
  $c1      = sha1($_SERVER['HTTP_HOST'] . date('YmdHis') . $_SERVER['REMOTE_ADDR'] . time());
  $c2      = sha1(uniqid(rand(), 1) . time());
  $prodKey = substr($c1 . $c2, 0, 60);
} elseif (function_exists('md5')) {
  $c1      = md5($_SERVER['HTTP_POST'] . date('YmdHis') . $_SERVER['REMOTE_ADDR'] . time());
  $c2      = md5(uniqid(rand(), 1), time());
  $prodKey = substr($c1 . $c2, 0, 60);
} else {
  $c1      = str_replace('.', '', uniqid(rand(), 1));
  $c2      = str_replace('.', '', uniqid(rand(), 1));
  $c3      = str_replace('.', '', uniqid(rand(), 1));
  $prodKey = substr($c1 . $c2 . $c3, 0, 60);
}

$prodKey = strtoupper($prodKey);

?>