<?php

if (!defined('PARENT')) {
  msw403();
}

$v      = (isset($_POST['mysql_version']) ? $_POST['mysql_version'] : 'MySQL4');
$c      = $_POST['charset'];
$tableD = array();

switch ($v) {
  case 'MySQL4':
    if ($c) {
      $split     = explode('_', $c);
      $tableType = 'DEFAULT CHARACTER SET ' . $split[0] . PHP_EOL;
      $tableType .= 'COLLATE ' . $c . PHP_EOL;
      define('DB_COLLATION', $c);
    }
    $tableType .= 'TYPE = MyISAM';
    break;
  case 'MySQL5':
    if ($c) {
      $split     = explode('_', $c);
      $tableType = 'CHARSET ' . $split[0] . PHP_EOL;
      $tableType .= 'COLLATE ' . $c . PHP_EOL;
      define('DB_COLLATION', $c);
    }
    $tableType .= 'ENGINE = MyISAM';
    break;
}

//============================================================
// INSTALL TABLE...ATTACHMENTS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "attachments`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "attachments` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `ticketID` varchar(20) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `replyID` int(11) NOT NULL DEFAULT '0',
  `department` int(5) NOT NULL DEFAULT '0',
  `fileName` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `fileSize` varchar(20) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `mimeType` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `repid_index` (`replyID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'attachments';
  mswlogDBError(DB_PREFIX . 'attachments', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...BAN..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "ban`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "ban` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `ip` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `count` int(5) NOT NULL DEFAULT '0',
  `banstamp` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'ban';
  mswlogDBError(DB_PREFIX . 'ban', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...CATEGORIES..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "categories`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "categories` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `summary` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `enCat` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `subcat` int(5) NOT NULL DEFAULT '0',
  `private` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'categories';
  mswlogDBError(DB_PREFIX . 'categories', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...CUSFIELDS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "cusfields`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "cusfields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fieldInstructions` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `fieldType` enum('textarea','input','select','checkbox') NOT NULL DEFAULT 'input',
  `fieldReq` enum('yes','no') NOT NULL DEFAULT 'no',
  `fieldOptions` text default null COLLATE " . DB_COLLATION . ",
  `fieldLoc` varchar(25) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `repeatPref` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enField` enum('yes','no') NOT NULL DEFAULT 'yes',
  `departments` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'cusfields';
  mswlogDBError(DB_PREFIX . 'cusfields', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...DEPARTMENTS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "departments`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "departments` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `showDept` enum('yes','no') NOT NULL DEFAULT 'no',
  `dept_subject` text default null COLLATE " . DB_COLLATION . ",
  `dept_comments` text default null COLLATE " . DB_COLLATION . ",
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `manual_assign` enum('yes','no') NOT NULL DEFAULT 'no',
  `days` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'departments';
  mswlogDBError(DB_PREFIX . 'departments', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...DISPUTES..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "disputes`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "disputes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticketID` int(15) NOT NULL DEFAULT '0',
  `visitorID` int(8) NOT NULL DEFAULT '0',
  `postPrivileges` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  INDEX `tickid_index` (`ticketID`),
  INDEX `vis_index` (`visitorID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'disputes';
  mswlogDBError(DB_PREFIX . 'disputes', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...FAQ..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "faq`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "faq` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `question` text default null COLLATE " . DB_COLLATION . ",
  `answer` text default null COLLATE " . DB_COLLATION . ",
  `kviews` int(10) NOT NULL DEFAULT '0',
  `kuseful` int(10) NOT NULL DEFAULT '0',
  `knotuseful` int(10) NOT NULL DEFAULT '0',
  `enFaq` enum('yes','no') NOT NULL DEFAULT 'yes',
  `featured` enum('yes','no') NOT NULL DEFAULT 'no',
  `orderBy` int(5) NOT NULL DEFAULT '0',
  `private` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'faq';
  mswlogDBError(DB_PREFIX . 'faq', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...FAQASSIGN..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "faqassign`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "faqassign` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `question` int(7) NOT NULL DEFAULT '0',
  `itemID` int(7) NOT NULL DEFAULT '0',
  `desc` varchar(20) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `que_index` (`question`),
  KEY `att_index` (`itemID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'faqassign';
  mswlogDBError(DB_PREFIX . 'faqassign', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...FAQATTACH..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "faqattach`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "faqattach` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `name` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `remote` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `path` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `size` varchar(30) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `enAtt` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mimeType` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'faqattach';
  mswlogDBError(DB_PREFIX . 'faqattach', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...IMAP..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "imap`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "imap` (
  `id` int(8) unsigned NOT NULL AUTO_INCREMENT,
  `im_piping` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_protocol` enum('pop3','imap') NOT NULL DEFAULT 'pop3',
  `im_host` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_user` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_pass` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_port` int(5) NOT NULL DEFAULT '110',
  `im_name` varchar(50) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_flags` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_attach` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_move` varchar(50) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_messages` int(3) NOT NULL DEFAULT '20',
  `im_ssl` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_priority` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_dept` int(5) NOT NULL DEFAULT '0',
  `im_email` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `im_spam` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_spam_purge` enum('yes','no') NOT NULL DEFAULT 'no',
  `im_score` varchar(10) NOT NULL DEFAULT '1.0' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'imap';
  mswlogDBError(DB_PREFIX . 'imap', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...IMAP_B8..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "imap_b8`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "imap_b8` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tokens` int(5) NOT NULL DEFAULT '0',
  `min_size` int(5) NOT NULL DEFAULT '0',
  `max_size` int(5) NOT NULL DEFAULT '0',
  `min_dev` varchar(5) NOT NULL DEFAULT '0.5' COLLATE " . DB_COLLATION . ",
  `x_constant` varchar(5) NOT NULL DEFAULT '0.5' COLLATE " . DB_COLLATION . ",
  `s_constant` varchar(5) NOT NULL DEFAULT '0.3' COLLATE " . DB_COLLATION . ",
  `learning` enum('yes','no') NOT NULL DEFAULT 'yes',
  `num_parse` enum('yes','no') NOT NULL DEFAULT 'no',
  `uri_parse` enum('yes','no') NOT NULL DEFAULT 'yes',
  `html_parse` enum('yes','no') NOT NULL DEFAULT 'yes',
  `multibyte` enum('yes','no') NOT NULL DEFAULT 'no',
  `encoder` varchar(50) NOT NULL DEFAULT 'utf-8' COLLATE " . DB_COLLATION . ",
  `skipFilters` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'imap_b8';
  mswlogDBError(DB_PREFIX . 'imap_b8', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...IMAP_B8_FILTER..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "imap_b8_filter`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "imap_b8_filter` (
  `token` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `count_ham` int(10) unsigned NOT NULL DEFAULT '0',
  `count_spam` int(10) unsigned NOT NULL DEFAULT '0',
  `ts` int(30) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'imap_b8_filter';
  mswlogDBError(DB_PREFIX . 'imap_b8_filter', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...LEVELS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "levels`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "levels` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `display` enum('yes','no') NOT NULL DEFAULT 'no',
  `marker` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `orderBy` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'levels';
  mswlogDBError(DB_PREFIX . 'levels', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...LOG..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "log`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `userID` int(5) NOT NULL DEFAULT '0',
  `ip` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `type` enum('user','acc') NOT NULL DEFAULT 'user',
  PRIMARY KEY (`id`),
  INDEX `useid_index` (`userID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'log';
  mswlogDBError(DB_PREFIX . 'log', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...MAILASSOC..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "mailassoc`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "mailassoc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staffID` int(8) NOT NULL DEFAULT '0',
  `mailID` int(8) NOT NULL DEFAULT '0',
  `folder` varchar(10) NOT NULL DEFAULT 'inbox' COLLATE " . DB_COLLATION . ",
  `status` enum('read','unread') NOT NULL DEFAULT 'unread',
  `lastUpdate` int(30) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `staff_index` (`staffID`),
  KEY `mail_index` (`mailID`),
  KEY `status_index` (`status`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'mailassoc';
  mswlogDBError(DB_PREFIX . 'mailassoc', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...MAILBOX..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "mailbox`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "mailbox` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `staffID` int(8) NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `message` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `staff_index` (`staffID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'mailbox';
  mswlogDBError(DB_PREFIX . 'mailbox', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...MAILFOLDERS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "mailfolders`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "mailfolders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `staffID` int(8) NOT NULL DEFAULT '0',
  `folder` varchar(50) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `staff_index` (`staffID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'mailfolders';
  mswlogDBError(DB_PREFIX . 'mailfolders', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...MAILREPLIES..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "mailreplies`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "mailreplies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `mailID` int(8) NOT NULL DEFAULT '0',
  `staffID` int(8) NOT NULL DEFAULT '0',
  `message` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `mail_index` (`mailID`),
  KEY `staff_index` (`staffID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'mailreplies';
  mswlogDBError(DB_PREFIX . 'mailreplies', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...PAGES..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "pages`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "pages` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `title` text default null COLLATE " . DB_COLLATION . ",
  `information` text default null COLLATE " . DB_COLLATION . ",
  `enPage` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `secure` enum('yes','no') NOT NULL DEFAULT 'no',
  `accounts` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'pages';
  mswlogDBError(DB_PREFIX . 'pages', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...PORTAL..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "portal`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "portal` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `ts` int(30) NOT NULL DEFAULT '0',
  `email` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `userPass` varchar(40) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  `verified` enum('yes','no') NOT NULL DEFAULT 'no',
  `timezone` varchar(50) NOT NULL DEFAULT '0' COLLATE " . DB_COLLATION . ",
  `ip` text default null COLLATE " . DB_COLLATION . ",
  `notes` text default null COLLATE " . DB_COLLATION . ",
  `reason` text default null COLLATE " . DB_COLLATION . ",
  `system1` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `system2` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `language` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `enableLog` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `em_index` (`email`),
  KEY `nm_index` (`name`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'portal';
  mswlogDBError(DB_PREFIX . 'portal', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...REPLIES..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "replies`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "replies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `ticketID` int(15) NOT NULL DEFAULT '0',
  `comments` text default null COLLATE " . DB_COLLATION . ",
  `mailBodyFilter` varchar(30) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `replyType` enum('none','visitor','admin') NOT NULL DEFAULT 'none',
  `replyUser` int(8) NOT NULL DEFAULT '0',
  `isMerged` enum('yes','no') NOT NULL DEFAULT 'no',
  `ipAddresses` text default null COLLATE " . DB_COLLATION . ",
  `disputeUser` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `repuse_index` (`replyUser`),
  KEY `disuse_index` (`disputeUser`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'replies';
  mswlogDBError(DB_PREFIX . 'replies', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...RESPONSES..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "responses`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "responses` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `title` text default null COLLATE " . DB_COLLATION . ",
  `answer` text default null COLLATE " . DB_COLLATION . ",
  `enResponse` enum('yes','no') NOT NULL DEFAULT 'yes',
  `orderBy` int(8) NOT NULL DEFAULT '0',
  `departments` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'responses';
  mswlogDBError(DB_PREFIX . 'responses', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...SETTINGS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "settings`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "settings` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `website` varchar(150) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `email` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `replyto` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `scriptpath` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `attachpath` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `attachhref` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `attachpathfaq` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `attachhreffaq` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `language` varchar(250) DEFAULT 'english' COLLATE " . DB_COLLATION . ",
  `langSets` text default null COLLATE " . DB_COLLATION . ",
  `dateformat` varchar(20) NOT NULL DEFAULT 'D j M Y, G:ia' COLLATE " . DB_COLLATION . ",
  `timeformat` varchar(15) NOT NULL DEFAULT 'H:iA' COLLATE " . DB_COLLATION . ",
  `timezone` varchar(50) NOT NULL DEFAULT 'Europe/London' COLLATE " . DB_COLLATION . ",
  `weekStart` enum('mon','sun') NOT NULL DEFAULT 'sun',
  `jsDateFormat` varchar(15) NOT NULL DEFAULT 'DD/MM/YYYY' COLLATE " . DB_COLLATION . ",
  `kbase` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enableVotes` enum('yes','no') NOT NULL DEFAULT 'yes',
  `multiplevotes` enum('yes','no') NOT NULL DEFAULT 'no',
  `popquestions` int(5) NOT NULL DEFAULT '0',
  `quePerPage` int(3) NOT NULL DEFAULT '10',
  `cookiedays` int(5) NOT NULL DEFAULT '0',
  `renamefaq` enum('yes','no') NOT NULL DEFAULT 'no',
  `attachment` enum('yes','no') NOT NULL DEFAULT 'no',
  `rename` enum('yes','no') NOT NULL DEFAULT 'no',
  `attachboxes` int(3) NOT NULL DEFAULT '2',
  `filetypes` text default null COLLATE " . DB_COLLATION . ",
  `maxsize` int(15) NOT NULL DEFAULT '200',
  `enableBBCode` enum('yes','no') NOT NULL DEFAULT 'yes',
  `afolder` varchar(50) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `autoClose` int(5) NOT NULL DEFAULT '0',
  `autoCloseMail` enum('yes','no') NOT NULL DEFAULT 'yes',
  `smtp_host` varchar(100) NOT NULL DEFAULT 'localhost' COLLATE " . DB_COLLATION . ",
  `smtp_user` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `smtp_pass` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `smtp_port` int(4) NOT NULL DEFAULT '25',
  `smtp_security` varchar(10) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `smtp_debug` enum('yes','no') NOT NULL DEFAULT 'no',
  `prodKey` char(60) NOT NULL DEFAULT '',
  `publicFooter` text default null COLLATE " . DB_COLLATION . ",
  `adminFooter` text default null COLLATE " . DB_COLLATION . ",
  `encoderVersion` varchar(5) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `softwareVersion` varchar(10) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `apiKey` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `apiLog` enum('yes','no') NOT NULL DEFAULT 'no',
  `apiHandlers` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `recaptchaPublicKey` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `recaptchaPrivateKey` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `enCapLogin` enum('yes','no') NOT NULL DEFAULT 'yes',
  `sysstatus` enum('yes','no') NOT NULL DEFAULT 'yes',
  `autoenable` date NOT NULL DEFAULT '1970-01-01',
  `disputes` enum('yes','no') NOT NULL DEFAULT 'no',
  `offlineReason` text default null COLLATE " . DB_COLLATION . ",
  `createPref` enum('yes','no') NOT NULL DEFAULT 'yes',
  `createAcc` enum('yes','no') NOT NULL DEFAULT 'yes',
  `loginLimit` int(5) NOT NULL DEFAULT '0',
  `banTime` int(5) NOT NULL DEFAULT '0',
  `ticketHistory` enum('yes','no') NOT NULL DEFAULT 'yes',
  `backupEmails` text default null COLLATE " . DB_COLLATION . ",
  `closenotify` enum('yes','no') NOT NULL DEFAULT 'no',
  `minPassValue` int(3) NOT NULL DEFAULT '8',
  `accProfNotify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `newAccNotify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `recaptchaTheme` varchar(20) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `recaptchaLang` varchar(10) NOT NULL DEFAULT 'en-GB' COLLATE " . DB_COLLATION . ",
  `enableLog` enum('yes','no') NOT NULL DEFAULT 'yes',
  `defKeepLogs` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `minTickDigits` int(2) NOT NULL DEFAULT '5',
  `enableMail` enum('yes','no') NOT NULL DEFAULT 'yes',
  `imap_debug` enum('yes','no') NOT NULL DEFAULT 'no',
  `imap_param` varchar(10) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `imap_memory` varchar(3) NOT NULL DEFAULT '10' COLLATE " . DB_COLLATION . ",
  `imap_timeout` varchar(3) NOT NULL DEFAULT '120' COLLATE " . DB_COLLATION . ",
  `imap_attach` enum('yes','no') NOT NULL DEFAULT 'no',
  `imap_notify` enum('yes','no') NOT NULL DEFAULT 'no',
  `disputeAdminStop` enum('yes','no') NOT NULL DEFAULT 'no',
  `faqcounts` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'settings';
  mswlogDBError(DB_PREFIX . 'settings', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...TICKETFIELDS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "ticketfields`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "ticketfields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ticketID` varchar(20) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `fieldID` int(15) NOT NULL DEFAULT '0',
  `replyID` int(15) NOT NULL DEFAULT '0',
  `fieldData` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `tickid_index` (`ticketID`),
  KEY `fldid_index` (`fieldID`),
  KEY `repid_index` (`replyID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'ticketfields';
  mswlogDBError(DB_PREFIX . 'ticketfields', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...TICKETHISTORY..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "tickethistory`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "tickethistory` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `ticketID` int(11) NOT NULL DEFAULT '0',
  `action` text default null COLLATE " . DB_COLLATION . ",
  `ip` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `ticket_index` (`ticketID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'tickethistory';
  mswlogDBError(DB_PREFIX . 'tickethistory', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...TICKETS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "tickets`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `lastrevision` int(30) NOT NULL DEFAULT '0',
  `department` int(8) NOT NULL DEFAULT '0',
  `assignedto` varchar(200) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `visitorID` int(8) NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `mailBodyFilter` varchar(30) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `comments` text default null COLLATE " . DB_COLLATION . ",
  `priority` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `replyStatus` enum('start','visitor','admin') NOT NULL DEFAULT 'start',
  `ticketStatus` enum('open','close','closed') NOT NULL DEFAULT 'open',
  `ipAddresses` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `ticketNotes` text default null COLLATE " . DB_COLLATION . ",
  `isDisputed` enum('yes','no') NOT NULL DEFAULT 'no',
  `disPostPriv` enum('yes','no') NOT NULL DEFAULT 'yes',
  `source` varchar(10) NOT NULL DEFAULT 'standard' COLLATE " . DB_COLLATION . ",
  `spamFlag` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `depid_index` (`department`),
  KEY `pry_index` (`priority`),
  KEY `isdis_index` (`isDisputed`),
  KEY `ts_index` (`ts`),
  KEY `vis_index` (`visitorID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'tickets';
  mswlogDBError(DB_PREFIX . 'tickets', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...USERDEPTS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "userdepts`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "userdepts` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `userID` int(5) NOT NULL DEFAULT '0',
  `deptID` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid_index` (`userID`),
  KEY `depid_index` (`deptID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'userdepts';
  mswlogDBError(DB_PREFIX . 'userdepts', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...USERS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "users`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "users` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `ts` int(30) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `email` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `email2` text default null COLLATE " . DB_COLLATION . ",
  `accpass` varchar(40) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `signature` text default null COLLATE " . DB_COLLATION . ",
  `notify` enum('yes','no') NOT NULL DEFAULT 'yes',
  `pageAccess` text default null COLLATE " . DB_COLLATION . ",
  `emailSigs` enum('yes','no') NOT NULL DEFAULT 'no',
  `notePadEnable` enum('yes','no') NOT NULL DEFAULT 'yes',
  `delPriv` enum('yes','no') NOT NULL DEFAULT 'no',
  `nameFrom` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `emailFrom` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `assigned` enum('yes','no') NOT NULL DEFAULT 'no',
  `timezone` varchar(50) NOT NULL DEFAULT '0' COLLATE " . DB_COLLATION . ",
  `enabled` enum('yes','no') NOT NULL DEFAULT 'yes',
  `notes` text default null COLLATE " . DB_COLLATION . ",
  `ticketHistory` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enableLog` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailbox` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailFolders` int(3) NOT NULL DEFAULT '5',
  `mailDeletion` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailScreen` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailCopy` enum('yes','no') NOT NULL DEFAULT 'yes',
  `mailPurge` int(3) NOT NULL DEFAULT '0',
  `addpages` text default null COLLATE " . DB_COLLATION . ",
  `mergeperms` enum('yes','no') NOT NULL DEFAULT 'yes',
  `digest` enum('yes','no') NOT NULL DEFAULT 'yes',
  `digestasg` enum('yes','no') NOT NULL DEFAULT 'no',
  `profile` enum('yes','no') NOT NULL DEFAULT 'yes',
  `helplink` enum('yes','no') NOT NULL DEFAULT 'no',
  `defDays` int(3) NOT NULL DEFAULT '45',
  `editperms` text default null COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `email_index` (`email`),
  KEY `nty_index` (`notify`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'users';
  mswlogDBError(DB_PREFIX . 'users', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

//============================================================
// INSTALL TABLE...USERSACCESS..
//============================================================

mysqli_query($GLOBALS["___mysqli_ston"], "DROP TABLE IF EXISTS `" . DB_PREFIX . "usersaccess`");
$query = mysqli_query($GLOBALS["___mysqli_ston"], "
CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "usersaccess` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `page` varchar(100) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `userID` varchar(250) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  `type` varchar(32) NOT NULL DEFAULT '' COLLATE " . DB_COLLATION . ",
  PRIMARY KEY (`id`),
  KEY `user_index` (`userID`)
) $tableType");

if (!$query) {
  $tableD[] = DB_PREFIX . 'tickets';
  mswlogDBError(DB_PREFIX . 'tickets', ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_error($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_error()) ? $___mysqli_res : false)), ((is_object($GLOBALS["___mysqli_ston"])) ? mysqli_errno($GLOBALS["___mysqli_ston"]) : (($___mysqli_res = mysqli_connect_errno()) ? $___mysqli_res : false)), __LINE__, __FILE__);
}

?>