<?php

@session_start();

date_default_timezone_set('UTC');

define('PATH', dirname(__file__) . '/');
define('INC', 1);
define('PARENT', 1);
define('REL_PATH', substr(PATH, 0, strpos(PATH, 'install') - 1) . '/');
define('RSS_BUILD_DATE_FORMAT', date('D, j M Y H:i:s T'));
define('UPGRADE_ROUTINE', 'yes');

if (!function_exists('mysqli_connect')) {
  die('!!! <b>The mysqli functions are not enabled on your server. Your must enable these functions before you can continue.</b><br><br>
  <a href="http://php.net/manual/en/book.mysqli.php">http://php.net/manual/en/book.mysqli.php</a>');
}

include(REL_PATH . 'control/classes/class.errors.php');
if (ERR_HANDLER_ENABLED) {
  set_error_handler('msErrorhandler');
}

include(REL_PATH . 'control/connect.php');
include(REL_PATH . 'control/system/constants.php');
include(REL_PATH . 'control/functions.php');
include(REL_PATH . 'control/timezones.php');

mswfileController();

$title     = SCRIPT_NAME . ': Upgrade Routine';
$tableType = '';
$ops       = array();

mswDBConnector();

// LOAD SETTINGS DATA..
// We can mask the error thrown here and redirect index file to installer..
$SETTINGS = @mysqli_fetch_object(mysqli_query($GLOBALS["___mysqli_ston"], "SELECT * FROM " . DB_PREFIX . "settings LIMIT 1"));

// CHECK INSTALLER..
if (!isset($SETTINGS->language)) {
  header("Location: index.php");
  exit;
}

// Table and collation..
$qCSVer = @mysqli_query($GLOBALS["___mysqli_ston"], "SHOW VARIABLES");
$VARS   = @mysqli_fetch_object($qCSVer);
if (is_object($VARS)) {
  $VARS = (array) $VARS;
  if (isset($VARS['character_set_database'])) {
    $tableType = 'CHARSET ' . $VARS['character_set_database'] . PHP_EOL;
    $tableType .= 'COLLATE ' . $VARS['collation_database'] . PHP_EOL;
  }
  if (isset($VARS['version'])) {
    if ($VARS['version'] < 5) {
      $tableType .= 'TYPE = MyISAM';
    } else {
      $tableType .= 'ENGINE = MyISAM';
    }
  } else {
    $tableType .= 'ENGINE = MyISAM';
  }
}

// Legacy version..
if (!isset($SETTINGS->encoderVersion)) {
  die('Version appears to be older than 2.0. Upgrade not possible, sorry.');
}

// v2.0..
if (!isset($SETTINGS->softwareVersion)) {
  $SETTINGS->softwareVersion = '2.0';
}

include(PATH . 'control/functions.php');

if (isset($_GET['upgrade'])) {
  include(PATH . 'control/upgrade-routine.php');
}

if (isset($_GET['completed'])) {
  include(PATH . 'templates/header.php');
  include(PATH . 'templates/upgrade-completed.php');
  include(PATH . 'templates/footer.php');
  exit;
}

include(PATH . 'templates/header.php');
include(PATH . 'templates/upgrade.php');
include(PATH . 'templates/footer.php');

?>